(function($) {

	$.fn.renderEmotion = function(emotion, color, radius, x, y, distance, angle, fontSize, caatElement) {
		var renderX = x + distance * Math.cos(angle);
		var renderY = y + distance * Math.sin(angle);		
		var lineHeight = Math.floor(fontSize * 1.5);
		this
			// The emotion node
			.addLayer({				
				"type"        : "arc",
				"name"        : emotion + "_node",
				"fillStyle"   : color,
				"x"           : renderX,
				"y"           : renderY,
				"radius"      : radius,
				"cursor"      : "pointer",
				"strokeStyle" : "#555555",
				"strokeWidth" : 1,
				"data"        : {
					"selected" : false,
					"borderSelected" : "#000000",
					"borderUnselected" : "#555555",
					"click"  : function(nodeLayer) {
						if(this.selected) {
							if($(caatElement).caat("deselectEmotion", emotion)) {
								nodeLayer.strokeWidth = 1;
								nodeLayer.strokeStyle = this.borderUnselected;
								this.selected = false;
								$(nodeLayer.canvas).drawLayers();
							}
						}
						else {
							if($(caatElement).caat("selectEmotion", emotion)) {
								nodeLayer.strokeWidth = 5;
								nodeLayer.strokeStyle = this.borderSelected;
								this.selected = true;
								$(nodeLayer.canvas).drawLayers();
							}
						}
					}
				},			
				"click" : function(layer) {
					layer.data.click(layer);
				}
			})
			// The text translucent background
			.addLayer({
				"type"         : "rectangle",
				"name"         : emotion + "_bg",
				"fillStyle"    : 'rgba(255, 255, 255, 0.5)',
				"x"            : renderX,
				"y"            : renderY,
				"cornerRadius" : 3,
				"width"        : this.measureCaatText(fontSize + "px Tahoma, Geneva, sans-serif", emotion) + 5,
				"height"       : lineHeight,
				"cursor"       : "pointer",			
				"click"        : function(layer) {
					$(this).getLayer(emotion + "_node").data.click($(this).getLayer(emotion + "_node"));
				}
			})
			// The emotion text
			.addLayer({
				"type"       : "text",
				"name"       : emotion + "_text",
				"fillStyle"  : "#000000",
				"fontSize"   : fontSize + "px",
				"fontFamily" : "Tahoma, Geneva, sans-serif",
				"x"          : renderX,
				"y"          : renderY,
				"text"       : emotion,
				"cursor"     : "pointer",
				"click"      : function(layer) {
					$(this).getLayer(emotion + "_node").data.click($(this).getLayer(emotion + "_node"));
				}
			});
		return this;
	};
	
	$.widget("fctimg.caat", {  
		//==========================================================================================================================
		// Default options
		//==========================================================================================================================
		options : {
			// options
			"openSide" : 500,
			
			// callbacks
			"onOpen" : null,
			"onClose" : null,
			"onChange" : null
		},
		
		//==========================================================================================================================
		// PUBLIC. Set an emotion as selected.
		//==========================================================================================================================
		selectEmotion : function(emotion) {		
			if(this.selection.emotion1 != null && this.selection.emotion2 != null) {
				return false;	
			}			
			else if(this.selection.emotion1 != emotion && this.selection.emotion2 != emotion) {
				// Update the discrete selection
				if(this.selection.emotion1 == null) {
					this.selection.emotion1 = emotion;
				}
				else if(this.selection.emotion2 == null) {
					this.selection.emotion2 = emotion;
				}
				
				// Update the continuous selection				
				if(this.selection.emotion1 != null && this.selection.emotion2 != null) {
					var emotion1Scores = this.scores[this.selection.emotion1];
					var emotion2Scores = this.scores[this.selection.emotion2];
					this.selection.s1 = (emotion1Scores.s1 + emotion2Scores.s1) / 2;
					this.selection.s2 = (emotion1Scores.s2 + emotion2Scores.s2) / 2;
				}
				else if(this.selection.emotion1 != null) {
					var emotion1Scores = this.scores[this.selection.emotion1];
					this.selection.s1 = emotion1Scores.s1;
					this.selection.s2 = emotion1Scores.s2;
				}
				else if(this.selection.emotion2 != null) {
					var emotion2Scores = this.scores[this.selection.emotion2];
					this.selection.s1 = emotion2Scores.s1;
					this.selection.s2 = emotion2Scores.s2;
				}
				this._trigger("onChange", null, this.element);
				this._updateTextBox();
				this._updateSubmissibles();
				return true;
			}
		},
		
		//==========================================================================================================================
		// PUBLIC. Deselects a previously selected emotion.
		//==========================================================================================================================
		deselectEmotion : function(emotion) {
			// Update the discrete selection
			if(this.selection.emotion1 == emotion) 
				this.selection.emotion1 = null;			
			else if(this.selection.emotion2 == emotion)
				this.selection.emotion2 = null;
			else
				return false;
			
			// Update the continuous selection 
			if(this.selection.emotion1 == null && this.selection.emotion2 == null) {
				this.selection.s1 = null;
				this.selection.s2 = null;
			}
			else if(this.selection.emotion2 == null) {			
				var emotion1Scores = this.scores[this.selection.emotion1];
				this.selection.s1 = emotion1Scores.s1;
				this.selection.s2 = emotion1Scores.s2;
			}
			else if(this.selection.emotion1 == null) {
				var emotion2Scores = this.scores[this.selection.emotion2];
				this.selection.s1 = emotion2Scores.s1;
				this.selection.s2 = emotion2Scores.s2;
			}
			
			this._trigger("onChange", null, this.element);				
			this._updateTextBox();
			this._updateSubmissibles();		
			return true;
		},
		
		//==========================================================================================================================
		// PUBLIC. Returns the emotion selection.
		//==========================================================================================================================
		getSelection : function() {		
			return this.selection;
		},

		//==========================================================================================================================
		// PUBLIC. Returns a string description of this caat instance.
		//==========================================================================================================================		
		toString : function() {
			return "{id: " + this.element.attr('id') + ", emotion1: " + this.selection.emotion1 + ", emotion2: " + this.selection.emotion2 +", s1: " + this.selection.s1 + ", s2: " + this.selection.s2 + "}";			
		},
		
		//==========================================================================================================================
		// PRIVATE. Updates the submissible values, is the caat is submissible.
		//==========================================================================================================================		
		_updateSubmissibles : function() {
			if(this.isSubmissible) {				
				this.submitEmotion1.val(this.selection.emotion1);
				this.submitEmotion2.val(this.selection.emotion2);
				this.submitS1.val(this.selection.s1);
				this.submitS2.val(this.selection.s2);
			}
		},
		
		//==========================================================================================================================
		// PRIVATE. Updates this caat's text box
		//==========================================================================================================================
		_updateTextBox : function() {					
			if(this.selection.emotion1 != null && this.selection.emotion2 != null)
				this.textBox.val(this.selection.emotion1 + " & " + this.selection.emotion2);
			else if(this.selection.emotion1 != null)
				this.textBox.val(this.selection.emotion1);
			else if(this.selection.emotion2 != null)
				this.textBox.val(this.selection.emotion2);
			else
				this.textBox.val("");
		},
		
		//==========================================================================================================================
		// PUBLIC. Toggles caat's selection area visibility
		//==========================================================================================================================
		toggle : function() {			
			// show the selection area
			if(this.state == "close") {		
				this.caatOpenWrapper										
					.show()
					.position({
						"my" 		: "left top",
						"at" 		: "left bottom",
						"of" 		: this.caatCloseWrapper,
						"collision" : "flipfit flipfit",						
					});
				this.state = "open";
				this._trigger("onOpen", null, this.element);
				this.buttonToggle.css("background-color", "gray");
			}
			// hide the selection area
			else {
				this.caatOpenWrapper.hide();
				this.state = "close";
				this._trigger("onClose", null, this.element);
				this.buttonToggle.css("background-color", "");
			}
		},

		//==========================================================================================================================
		// PRIVATE. Constructor
		//==========================================================================================================================
		_create : function() {			
			// The emotions scores. The names of the emotions must be the same as the ones passed to renderEmotion
			this.scores = {
				"nothing"      : {"s1" : 4, "s2" : 4},
				"terror"       : {"s1" : 1, "s2" : 7},
				"fear"         : {"s1" : 2, "s2" : 6},
				"apprehension" : {"s1" : 3, "s2" : 5},
				"annoyance"    : {"s1" : 3.7, "s2" : 5},
				"anger"        : {"s1" : 3.3, "s2" : 6},
				"rage"         : {"s1" : 3, "s2" : 7},
				"admiration"   : {"s1" : 6.3, "s2" : 5},
				"trust"        : {"s1" : 5.7, "s2" : 4},
				"acceptance"   : {"s1" : 4.7, "s2" : 4},
				"boredom"      : {"s1" : 3.7, "s2" : 3},
				"disgust"      : {"s1" : 2.3, "s2" : 5},
				"loathing"     : {"s1" : 1.3, "s2" : 6},
				"ecstasy"      : {"s1" : 7, "s2" : 7},
				"joy"          : {"s1" : 6, "s2" : 6},
				"serenity"     : {"s1" : 5, "s2" : 3},			
				"pensiveness"  : {"s1" : 3, "s2" : 3},			
				"sadness"      : {"s1" : 2, "s2" : 2},			
				"grief"        : {"s1" : 1, "s2" : 1},							
				"vigilance"    : {"s1" : 5, "s2" : 7},			
				"anticipation" : {"s1" : 4.7, "s2" : 6},			
				"interest"     : {"s1" : 4.7, "s2" : 5},			
				"distraction"  : {"s1" : 3.7, "s2" : 3},			
				"surprise"     : {"s1" : 3.3, "s2" : 6},			
				"amazement"    : {"s1" : 3, "s2" : 7}
			};
			
			// The caat's state
			this.state = "close";
		
			// Disable (so it does not get submitted) and hide the anchor element
			this.element
				.prop("disabled", true)
				.css("visibility", "hidden");
				//.hide();
				
			// Create the selection object
			this.selection = {
				emotion1 : null,
				emotion2 : null,
				s1       : null,
				s2       : null
			};
				
			// If the caat as an attribute name, then the results will be submitted
			this.isSubmissible = false;
			if(this.element.attr('name')) {
				this.isSubmissible = true;
				this.submitEmotion1 = $('<input type="hidden" name="'+this.element.attr('name')+'_emotion1" value="">').insertAfter(this.element);
				this.submitEmotion2 = $('<input type="hidden" name="'+this.element.attr('name')+'_emotion2" value="">').insertAfter(this.element);
				this.submitS1 = $('<input type="hidden" name="'+this.element.attr('name')+'_s1" value="">').insertAfter(this.element);
				this.submitS2 = $('<input type="hidden" name="'+this.element.attr('name')+'_s2" value="">').insertAfter(this.element);
			}
			
			// WRAPPER -------------------------------------------------------------------------------------------------------------
			this.caatWrapper = $('<div>')
				.addClass('caat caat_wrapper')				
				.insertAfter(this.element)
				.position({
					"my" 		: "left top",
					"at" 		: "left top",
					"of" 		: this.element
				});
				
			
			// CLOSED STATE --------------------------------------------------------------------------------------------------------
			// Create a wrapper
			this.caatCloseWrapper = $('<div>')
				.addClass("caat caat_close_wrapper")
				.css('width', this.element.outerWidth()-2)
				.appendTo(this.caatWrapper);
				
			// Now, create a table to render caat's controls			
			var tdTextBox = $('<td>');
			var tdToggle = $('<td>')
				.addClass('caat td_button_toggle');
			var tr = $('<tr>')
				.append(tdTextBox)
				.append(tdToggle);
			var tableLayout = $('<table>')
				.addClass("caat layout_table")
				.append(tr)
				.appendTo(this.caatCloseWrapper);
			
			// Create and add the controls themselves
			this.textBox = $('<input>')
				.addClass('caat caat_text_box')
				.prop("readonly", true)
				.appendTo(tdTextBox);
			
			this.buttonToggle = $('<div>')
				.addClass('caat button_toggle')
				.css({					
					"height" : this.element.outerHeight()-2,
					"width" : this.element.outerHeight()-2					
				})
				.appendTo(tdToggle);			
						
			// OPEN STATE ----------------------------------------------------------------------------------------------------------
			// caat formatting options
			var caatSide = this.options.openSide;			
			var caatCenter = this.options.openSide / 2;
			var caatFontSize = (13 / 500) * caatSide;
			var caatFontProgress = caatFontSize * 0.33;
			var emotionGap = this.options.openSide * 0.005;		
			
			var tier0 = {
				"x" 	   : caatCenter,
				"y" 	   : caatCenter,
			    "radius"   : caatSide * 0.09,
				"fontSize" : caatFontSize + (0 * caatFontProgress)
			};
			var tier1 = {
				"radius"   : caatSide * 0.05,
				"distance" : function() { return tier0.radius + this.radius + emotionGap; },
				"fontSize" : caatFontSize + (0 * caatFontProgress)
			};
			var tier2 = {
				"radius"   : caatSide * 0.065,
				"distance" : function() { return tier1.distance() + tier1.radius + emotionGap + this.radius; },
				"fontSize" : caatFontSize + (1 * caatFontProgress)
			};
			var tier3 = {
				"radius"   : caatSide * 0.08,
				"distance" : function() { return tier2.distance() + tier2.radius + emotionGap + this.radius; },
				"fontSize" : caatFontSize + (2 * caatFontProgress)
			};
			
			// Create the wrapper for the opened caat
			this.caatOpenWrapper = $('<div>')
				.addClass("caat caat_open_wrapper")					
				.appendTo(this.caatWrapper)
				.position({
					"my" : "left top",
					"at" : "left bottom",
					"of" : this.caatCloseWrapper,
				})
				.hide();

			// Create the area where the instructions are presented to the user
			var areaInstructions = $('<div>')
				.addClass("caat div_instructions")
				.append(
					$('<span>Please select one or two emotions.</span>')
						.addClass("caat span_instructions")
				);
				
			// Create the emotion selection area
			var areaSelection = $('<canvas width="' + caatSide + '" height="' + caatSide + '"></canvas>')
				// central nothing
				.renderEmotion("nothing", "#DEDEDE", tier0.radius, tier0.x, tier0.y, 0, 0, tier0.fontSize, this.element)
				// Tier 3
				.renderEmotion("terror", 	   "#007B33", tier3.radius, tier0.x, tier0.y, tier3.distance(), 0, tier3.fontSize, this.element)
				.renderEmotion("admiration",   "#7BBD0D", tier3.radius, tier0.x, tier0.y, tier3.distance(), (7/4)*Math.PI, tier3.fontSize, this.element)
				.renderEmotion("ecstasy", 	   "#EDC500", tier3.radius, tier0.x, tier0.y, tier3.distance(), (3/2)*Math.PI, tier3.fontSize, this.element)
				.renderEmotion("vigilance",    "#E87200", tier3.radius, tier0.x, tier0.y, tier3.distance(), (5/4)*Math.PI, tier3.fontSize, this.element)
				.renderEmotion("rage", 		   "#DC0047", tier3.radius, tier0.x, tier0.y, tier3.distance(), Math.PI, tier3.fontSize, this.element)
				.renderEmotion("loathing", 	   "#7B4EA3", tier3.radius, tier0.x, tier0.y, tier3.distance(), (3/4)*Math.PI, tier3.fontSize, this.element)
				.renderEmotion("grief", 	   "#1F6CAD", tier3.radius, tier0.x, tier0.y, tier3.distance(), (1/2)*Math.PI, tier3.fontSize, this.element)
				.renderEmotion("amazement",    "#0081AB", tier3.radius, tier0.x, tier0.y, tier3.distance(), (1/4)*Math.PI, tier3.fontSize, this.element)
				// Tier 2
				.renderEmotion("fear", 		   "#53A76B", tier2.radius, tier0.x, tier0.y, tier2.distance(), 0, tier2.fontSize, this.element)
				.renderEmotion("trust", 	   "#B0D760", tier2.radius, tier0.x, tier0.y, tier2.distance(), (7/4)*Math.PI, tier2.fontSize, this.element)
				.renderEmotion("joy", 		   "#F6E56F", tier2.radius, tier0.x, tier0.y, tier2.distance(), (3/2)*Math.PI, tier2.fontSize, this.element)
				.renderEmotion("anticipation", "#F4AC58", tier2.radius, tier0.x, tier0.y, tier2.distance(), (5/4)*Math.PI, tier2.fontSize, this.element)
				.renderEmotion("anger", 	   "#EC607D", tier2.radius, tier0.x, tier0.y, tier2.distance(), Math.PI, tier2.fontSize, this.element)
				.renderEmotion("disgust", 	   "#AC86C1", tier2.radius, tier0.x, tier0.y, tier2.distance(), (3/4)*Math.PI, tier2.fontSize, this.element)
				.renderEmotion("sadness", 	   "#7FADD1", tier2.radius, tier0.x, tier0.y, tier2.distance(), (1/2)*Math.PI, tier2.fontSize, this.element)
				.renderEmotion("surprise", 	   "#68B0C8", tier2.radius, tier0.x, tier0.y, tier2.distance(), (1/4)*Math.PI, tier2.fontSize, this.element)
				// Tier 1
				.renderEmotion("apprehension", "#99CC99", tier1.radius, tier0.x, tier0.y, tier1.distance(), 0, tier1.fontSize, this.element)
				.renderEmotion("acceptance",   "#D8EB9D", tier1.radius, tier0.x, tier0.y, tier1.distance(), (7/4)*Math.PI, tier1.fontSize, this.element)
				.renderEmotion("serenity",     "#FFFFCC", tier1.radius, tier0.x, tier0.y, tier1.distance(), (3/2)*Math.PI, tier1.fontSize, this.element)
				.renderEmotion("interest",     "#FEDAA4", tier1.radius, tier0.x, tier0.y, tier1.distance(), (5/4)*Math.PI, tier1.fontSize, this.element)
				.renderEmotion("annoyance",    "#F8A6A4", tier1.radius, tier0.x, tier0.y, tier1.distance(), Math.PI, tier1.fontSize, this.element)
				.renderEmotion("boredom",  	   "#CEB2D8", tier1.radius, tier0.x, tier0.y, tier1.distance(), (3/4)*Math.PI, tier1.fontSize, this.element)
				.renderEmotion("pensiveness",  "#CBDEEC", tier1.radius, tier0.x, tier0.y, tier1.distance(), (1/2)*Math.PI, tier1.fontSize, this.element)
				.renderEmotion("distraction",  "#C1D7E2", tier1.radius, tier0.x, tier0.y, tier1.distance(), (1/4)*Math.PI, tier1.fontSize, this.element)
				// Finalize				
				.drawLayers();
				
			// The div with the caat's controls
			this.buttonOK = $('<button type="button">OK</button>')
				.addClass("caat button_ok");
			
			var areaControls = $('<div>')
				.addClass("caat div_controls")
				.append(this.buttonOK);
			
			// Append all of the caat's components - instructions, emotion selection area and the control area
			this.caatOpenWrapper
				.append(areaInstructions)
				.append(areaSelection)
				.append(areaControls);
			
			// Bind some events 
			this._on(this.buttonToggle, {
				"click" : "toggle"
			});
			this._on(this.buttonOK, {
				"click" : "toggle"
			});
							
		}
		
    });  
	
})(jQuery);  